rm(list = ls())
setwd("E:/2024.10.11 诊断医学统计平台/第12-14章 package")

#设计的数据集包含n个受试者，每个受试者有m个QIB指标，每个指标重复测量l次
#data是一个三维数组database[i,j,k]，i：受试者编号，j：QIB编号，k：测量次数编号。
#不妨假设m=1，数组退化为两维，即只针对一个指标分析

#with-subject standard deviation
#l=2:test-retest
wSDi <- function(data,i){
   k <- length(data[i,])
    wSDi <- sqrt(sum((data[i,]-mean(data[i,]))^2)/(k-1))
  return(wSDi)
}  

wSD <- function(data){
  n <- length(data[,1])
  l <- length(data[1,])
  temp <- matrix(NA,nrow = n,ncol=1)
  for(i in 1:n){
    temp[i,] <- wSDi(data,i)
  }
  wSD <- sqrt(sum(temp[,1]^2)/n)
  lwSD <- sqrt(n*(l-1)*wSD^2/qchisq(0.975,df=n*(l-1)))
  rwSD <- sqrt(n*(l-1)*wSD^2/qchisq(0.025,df=n*(l-1)))
  return(wSD,lwSD,rwSD)
}



#Repeatability Coefficient
#calculate RC and its CI
RC <- function(data){
  wSDRC <- wSD(data)$wSD
  RC <- 1.96*sqrt(2*wSDRC^2)
  lRC <- RC-RC*sqrt(n/qchisq(0.975,df=n*(l-1)))
  rRC <- RC+RC*sqrt(n/qchisq(0.975,df=n*(l-1)))
  return(RC,lRC,rRC)
}





#Within-subject coefficient of variation
wCV <- function(data){
  n <- length(data[,1])
  l <- length(data[1,])
  wsdi <- rep(0,times=n)
  y <- rep(0,times=n)
 for(i in 1:n){
   wsdi[i] <- wSDi(data,i) 
   y[i] <- mean(data[i,])
 }  
  wCV <- sqrt(sum(wsdi^2/y^2)/n)
  lwCV <- sqrt(n*(l-1)*wCV^2/qchisq(0.975,df=n*(l-1)))
  rwCV <- sqrt(n*(l-1)*wCV^2/qchisq(0.025,df=n*(l-1)))
  return(wCV,lwCV,rwCV)
}

wCVc <- function(data,beta1,beta0){
  n <- length(data[,1])
  l <- length(data[1,])
  wsdi <- rep(0,times=n)
  y <- rep(0,times=n)
  for(i in 1:n){
    wsdi[i] <- wSDi(data,i) 
    y[i] <- mean(data[i,])
  }  
  wCVc <- sqrt(sum((wsdi*beta1)^2/(y-beta0)^2)/n)
  return(wCVc)
}


#data <- log(data),repeat functions above :log transformation



#Estimation of Constant Bias
Di <- function(data,i,Xi){
  Di <- mean(data[i,])-Xi
  percentDi <- Di/Xi
  return(c(Di,percentDi))
}

D <- function(data,X){
  n <- length(data[,1])
  D_i <- rep(0,times = n)
  percentD_i <- rep(0,times = n)
  for(i in 1:n){
    D_i[i] <- Di(data,i,X[i])[1]
    percentD_i <- Di(data,i,X[i])[2]
  }
  D <- mean(D_i)
  percentD <- mean(percentD_i)
  return(c(D,percentD))
}

VarD <- function(data,X){
  Dhat <- D(data,X)[1]
  n <- length(data[,1])
  D_i <- rep(0,times = n)
  for(i in 1:n){
    D_i[i] <- Di(data,i,X[i])[1]
   }
  VarD <- sum((D_i-D)^2)/(n-1)
  lD <- D + qt(p=0.025,df=n-1)*sqrt(VarD)
  rD <- D - qt(p=0.025,df=n-1)*sqrt(VarD)
  return(VarD,lD,rD)
}




#Estimation of non-constant bias
Ybias <- function(data,X){
  n=length(data[,1])
  l=length(data[1,])
  temp <- matrix(data,nrow=n*l,ncol=2,byrow=FALSE)
  temp[,2] <- X
  colnames(temp) <- c("y","x")
  temp <- as.data.frame(temp)
  test <- lm(y~x,data=temp)
  beta1 <- test$coefficient[2]
  beta0 <- test$coefficient[1]
  lY <- (data-beta0)/beta1 - 1.96*wSD(data)/beta1
  rY <- (data-beta0)/beta1 + 1.96*wSD(data)/beta1
  return(lY,rY)
}





#Estimation of Change over Time
CoT <- function(data,X){
  n=length(data[,1])
  l=length(data[1,])
  temp <- matrix(data,nrow=n*l,ncol=2,byrow=FALSE)
  temp[,2] <- X
  colnames(temp) <- c("y","x")
  temp <- as.data.frame(temp)
  test <- lm(y~x,data=temp)
  beta1 <- test$coefficient[2]
  beta0 <- test$coefficient[1]
  CoT <- (data[,2]-data[,1])/beta1
  lCoT <- CoT - 1.96*sqrt(2*wSD(data)^2/beta1^2)
  rCoT <- CoT + 1.96*sqrt(2*wSD(data)^2/beta1^2)
  return(CoT,lCoT,rCoT)
}








